% Cross-validate localization of the reality-mining dataset
% Requires training_opt.m and testing_opt.m

% date ranges tested
date_list = datenum([
            2004,11,1,0,0,0;
            2004,12,1,0,0,0;
            2005,01,1,0,0,0;
            2005,02,1,0,0,0;
            2005,03,1,0,0,0
            ]);

% lengths of time tested
length_ranges = datenum([
    0,0,0,0,0,50;
    0,0,0,0,1,0;
    0,0,0,0,50,0;
    0,0,0,1,0,0;
    0,0,0,23,0,0;
    0,0,1,0,0,0;
    0,0,6,0,0,0;
    0,0,7,0,0,0;
    0,0,30,0,0,0;
    0,0,31,0,0,0
    ]);

% number of samples of each length of time
numrand = [1000, 100, 10, 10, 1, 1];

% store accuracy
corrects = zeros(size(length_ranges,1) / 2,4);
totals = zeros(size(length_ranges,1) / 2,4);

for update_plan=[1,2,3]
    for call_length=datenum([0,0,0,0,3,0])
        
        for dt = 1:size(date_list,1)-2
            first_month = date_list(dt:dt+1,:);

            [Ps, s_states, tcounts] = training_opt(update_plan, call_length, first_month,s);

            second_month = date_list(dt+1:dt+2,:);
            
            for lr = 1:2:size(length_ranges,1)
                
                length_range = length_ranges(lr:lr+1,:);
                nr = numrand((lr + 1) / 2);
                
                [correct, total] = testing_opt(Ps, s_states, update_plan, call_length, second_month, length_range,nr,s);

                corrects((lr+1)/2,update_plan) = corrects((lr+1)/2,update_plan) + correct;
                totals((lr+1)/2,update_plan) = totals((lr+1)/2,update_plan) + total;
                fprintf('%d, %d, %d: %d / %d (%f)\n',[update_plan, dt, lr, correct, total, correct/total])
            end;
        end;
    end;
end;
