import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;

public class PlotDataGenerator {

	// The following two hash maps help to obtain the average RTT per serial
	// number and friend_nick

	// This hash map stores key-value pairs of the form :
	// serial_num::friend_nick as key and sum of RTT measurements as value
	static HashMap<String, Double> sumRTTs = new HashMap<String, Double>();

	// This hash map stores key-value pairs of the form :
	// serial_num::friend_nick as key and as value
	static HashMap<String, Integer> countRTTData = new HashMap<String, Integer>();

	// This hash map stores key-value pairs of the form :
	// serial_num::friend_nick::filename as key and total delay less network RTT
	// as value
	static HashMap<String, Double> OneSwarmDelays = new HashMap<String, Double>();

	public static void main(String[] args) {
		int bound1 = Integer.parseInt(args[0]);
		int bound2 = Integer.parseInt(args[1]);
		try {

			FileInputStream fstream1 = new FileInputStream(
					"OneSwarmDemoRepo/NetworkRTTInfo.csv");
			DataInputStream in1 = new DataInputStream(fstream1);
			BufferedReader br1 = new BufferedReader(new InputStreamReader(in1));
			String strLine1;
			while ((strLine1 = br1.readLine()) != null) {
				String[] components1 = strLine1.split(",");
				try {
					int serialNum = Integer.parseInt(components1[5]);
					String friendNick = components1[2];
					double rtt = Double.parseDouble(components1[3]);
					String key = serialNum + "::" + friendNick;
					if (sumRTTs.containsKey(key)) {
						double val = sumRTTs.get(key);
						val += rtt;
						sumRTTs.put(key, val);
						int cnt = countRTTData.get(key);
						countRTTData.put(key, cnt + 1);
					} else {
						sumRTTs.put(key, rtt);
						countRTTData.put(key, 1);
					}

				} catch (NumberFormatException e) {
					continue;
				}

			}

			br1.close();
			in1.close();
		} catch (Exception e) {
		}

		// compute average RTT per serial number and friend_nick
		Iterator<String> itr = sumRTTs.keySet().iterator();
		while (itr.hasNext()) {
			String key = itr.next();
			double sum = sumRTTs.get(key);
			int count = countRTTData.get(key);
			double avg = sum / count;
			sumRTTs.put(key, avg);
		}

		try {

			FileInputStream fstream2 = new FileInputStream(
					"OneSwarmDemoRepo/TotalDelayInfo.csv");
			DataInputStream in2 = new DataInputStream(fstream2);
			BufferedReader br2 = new BufferedReader(new InputStreamReader(in2));
			String strLine2;
			while ((strLine2 = br2.readLine()) != null) {
				String[] components2 = strLine2.split(",");
				int serialNum;
				String friendNick;
				double delay = 0;
				try {
					serialNum = Integer.parseInt(components2[2]);
					friendNick = components2[4];
					delay = Double.parseDouble(components2[6]);

					String fileName = components2[7];
					String key = serialNum + "::" + friendNick;
					String key2 = serialNum + "::" + friendNick + "::"
							+ fileName;
					double rtt = sumRTTs.get(key);
					double OneSwarmDelay = delay - rtt;
					OneSwarmDelays.put(key2, OneSwarmDelay);
				} catch (NumberFormatException e) {

					continue;
				}

			}

			br2.close();
			in2.close();

		} catch (Exception e) {
		}

		// Print data for plotting and find minimum of scenario B (that is when
		// neighbor is not the source)
		double minB = 10000;
		System.out.println("SerialNumber,Delay");
		Iterator<String> iter = OneSwarmDelays.keySet().iterator();
		while (iter.hasNext()) {
			String key = iter.next();
			String keyComponents[] = key.split("::");
			int category = 0;
			int serial = Integer.parseInt(keyComponents[0]);
			if (serial <= bound1)
				category = 1;
			else if (serial <= bound2)
				category = 2;
			else
				category = 3;

			double OneSwarmDelay = OneSwarmDelays.get(key);
			if (OneSwarmDelay < 4000 && OneSwarmDelay >= 150) {
				if (OneSwarmDelay < minB && category == 2)
					minB = OneSwarmDelay;
				System.out.println(category + "," + OneSwarmDelay);
			}
		}

		// write into a file details of peers that are below threshold, i.e
		// minB. These are the neighbors that are sources of files with very
		// high probability

		try {
			FileWriter fstream = new FileWriter("Sources.txt");
			BufferedWriter out = new BufferedWriter(fstream);
			Iterator<String> iterator = OneSwarmDelays.keySet().iterator();
			while (iterator.hasNext()) {
				String key = iterator.next();
				double delayVal = OneSwarmDelays.get(key);
				String keyparts[] = key.split("::");
				if (delayVal > 150 && delayVal < minB) {
					out.write(keyparts[1]
							+ "  **with very high probaility** possesses the file : "
							+ keyparts[2] + "\n");
					out.write("\n");
				}
			}
			out.close();
		} catch (Exception e) {// Catch exception if any
		}

	}
}
