package oneswarm;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Random;

public class Sim {
    static Random r = new Random();
    final static int neighbors = 39; // or 20 if you want to test that paragraph at the end of section 5.2
	
    public static void main(String[] args) throws FileNotFoundException, UnsupportedEncodingException {
	r.setSeed(0);
	PrintWriter writer = new PrintWriter("results.tsv", "UTF-8");
	writer.printf("frac\tk\tcount\tN\n");
	int N = 1000; // number of nodes in sim
	for (double c=0.0;c<.75;c+=.001){ // the fraction that are attackers: 0<c<1
	    for(int runs=0;runs<1000;runs++){
		ArrayList <Node> nodes= new ArrayList<Node>(); // nodes that have under 40 peers
		ArrayList <Node> filled=new ArrayList<Node>(); // nodes that have 39 peers
		// initialize list; some are attackers
		for (int n=0;n<N;n++){
		    nodes.add(new Node(  n< ((int)(c*N))));	 // avoid floating point mishap
		}
		if (c==0.0){
		    for(Node n:nodes){
			if (n.attacker){
			    System.out.println("attacker is true");
			    System.exit(-1);
			}
		    }
		}
		//	select 39 neighbors for each node
		while (filled.size()<(N-10)){
		    // pick two random node
		    Node a = nodes.get(r.nextInt(nodes.size()));			
		    Node b = nodes.get(r.nextInt(nodes.size()));
		    if (a==b) continue; // make sure they aren't the same node
		    if (a.nbrs.contains(b)) 
			continue; // don't make the same nodes nbrs twice
		    a.nbrs.add(b); // make b the nbr of a
		    b.nbrs.add(a); // make a the nbr of b

		    // increase nbr count if necessary 
		    if (a.attacker==true) b.attackers++; 
		    if (b.attacker==true) a.attackers++;

		    // remove a or b from nodes list if they have 39 nbrs
		    if (a.nbrs.size()>=neighbors){  
			nodes.remove(a);
			filled.add(a);
		    }
		    if (b.nbrs.size()>=neighbors){
			nodes.remove(b);
			filled.add(b);
		    }
		}
		// stats on number of attackers partnered with each node
		for(int k=1;k<=10;k++){
		    int count = 0;
		    for(Node n:filled){
			if (n.attackers>=k)
			    count++;
		    }
		    writer.printf("%.3f\t%d\t%.3f\t %d\n",c,k,count/(float)filled.size(),filled.size());
		}
	    }
	}
	writer.close();
    }
}


