#include "utils.h"

Log::Log (){
	ackfd = fopen("acks.log","w");
	seqfd= fopen("seq.log","w");
}
void Log::writeAck(unsigned int ack,int time){
	fprintf(ackfd,"%d %u\n",time,ack);
	fflush(ackfd);
}
void Log::writeSeq(unsigned int ack,int time){
	fprintf(seqfd,"%d %u\n",time,ack);
	fflush(seqfd);
}	
void Log::close(){
	fclose(ackfd);
	fclose(seqfd);
}



void hexdump(void *ptr, int buflen) {
	unsigned char *buf = (unsigned char*)ptr;
	int i, j;
	for (i=0; i<buflen; i+=16) {
		printf("%06x: ", i);
		for (j=0; j<16; j++)
			if (i+j < buflen)
				if (j%2==0){ printf("%02x", buf[i+j]);} else {printf("%02x ", buf[i+j]);}
				else
					printf("   ");
		printf(" ");
		for (j=0; j<16; j++)
			if (i+j < buflen)
				printf("%c", isprint(buf[i+j]) ? buf[i+j] : '.');
		printf("\n");
	}
}


uint16_t  csum (uint16_t * addr, int len){
	int nleft = len;
	uint32_t sum = 0;
	uint16_t *w = addr;
	uint16_t answer = 0;
	
	while( nleft > 1 ) {
		sum += *w++;
		nleft -= 2;
	}
	if (nleft == 1) {
		*(unsigned char *)  (&answer) = *(unsigned char *) w;
		sum += answer;
	}
	sum = (sum >> 16)+(sum & 0xffff);
	sum += (sum >> 16);
	answer = ~sum;
	return (answer);
}



int diff_ms(timeval t1, timeval t2) {
    return (((t1.tv_sec - t2.tv_sec) * 1000000) + 
            (t1.tv_usec - t2.tv_usec))/1000;
}


void options (int argc, char **argv,char src_ip[], char dst_ip[], char get_path[], unsigned short &dst_port, int &augmentDenom, int &maxaug,unsigned char &ws){
	int flags = 0;
	int c = 0;
	while ((c = getopt(argc, argv, "s:d:p:a:D:w:g:")) != -1) {
		switch (c) {
			case 's':
				flags |= 0x1;
				snprintf(src_ip,16,"%s",optarg);
				break;
			case 'd':
				flags |= 0x2;
				snprintf(dst_ip,16,"%s",optarg);
				break;
			case 'p':
				flags |= 0x8;
				dst_port=atoi(optarg);
				break;
			case 'D':
				flags |= 0x8;
				augmentDenom=atoi(optarg);
				break;
			case 'a':
				flags |= 0x8;
				maxaug=atoi(optarg);
				break;
			case 'w':
				flags |= 0x8;
				ws=atoi(optarg);
				break;
			case 'g':
			        memset(get_path, 0, GET_PATH_LEN);
			       	strncpy(get_path, optarg, GET_PATH_LEN);
				break;
			case '?':
				flags |= 0x10;
				fprintf(stderr, "Unrecognized option  \n");
				break;
		}
	}
	
	if(! ( flags & 0x2  ) ) {
		fprintf(stderr,"\nrawsockets -s <source ip> -d <destination ip> \n");
		fprintf(stderr,"\nYou must give me a source, destination, and dest port. (Source port is random)\n");
		fprintf(stderr,"  Example:\n\t\tsudo ./attack -s 10.0.1.6 -d 128.119.245.135 [-p 80] [-w 4] [-a 10] [-D 3000]\nPlease check hard coded interface if you are having trouble.\n");
		exit(1);
	}
}

